/*
    ! file encoding: Windows-1251


   ------------------------------------------

      INI / ( mxINI )

   ------------------


     
        -  -  PAWN   GTA San Andreas (SA-MP)

     
        -      include,     
        -       #include <mxINI.inc>

    
         MX_Master

    
        0.5  20.09.2010


     
             

        ini_createFile ( "//.ini", "   " )

        ini_openFile ( "//.ini" )

        ini_closeFile ( __ )
    --
        ini_setString ( __, " ", " " )

        ini_setInteger ( __, " ", 123456 )

        ini_setFloat ( __, " ", 3.1416 )
    --
        ini_getString ( __, " ", returnValue )

        ini_getInteger ( __, " ", returnValue )

        ini_getFloat ( __, " ", returnValue )
    --
        ini_removeKey ( __, " " )

        ini_getErrorInfo ( _ )


    

        new iniFile = ini_createFile ( "test4268.ini" );

        if ( iniFile < 0 )
            iniFile = ini_openFile ( "test4268.ini" );

        if ( iniFile >= 0 )
        {
            new returnString[32], returnNumber, Float: returnFloat;

            ini_setString  ( iniFile, "  ", " " );
            ini_setInteger ( iniFile, "  ",   123456 );
            ini_setFloat   ( iniFile, "  ",   3.1416 );

            ini_removeKey  ( iniFile, "  " );

            ini_getString  ( iniFile, "  ", returnString );
            ini_getInteger ( iniFile, "  ",   returnNumber );
            ini_getFloat   ( iniFile, "  ",   returnFloat );


            ini_closeFile  ( iniFile );

            printf ( "\n `__` = `%s`,\n `__` = `%d`,\n `__` = `%f` \n",
                returnString, returnNumber, returnFloat );
        }
        else print( "\n    INI  \n" );
*/











const

    // 

    //    
    INI_MAX_OPENED_FILES    = 30,        // ,  , 
    INI_MAX_FILE_SIZE       = 65536,    // ,        .  
    INI_MAX_FILENAME_SIZE   = 128,      // ,    .    
    INI_MAX_KEYS_IN_FILE    = 2048,     //     

    //            :
    // INI_MAX_OPENED_FILES * ( INI_MAX_FILE_SIZE + INI_MAX_FILENAME_SIZE*4 + INI_MAX_KEYS_IN_FILE*4 )


    //  
    INI_INTEGER_SIZE        = 12,       //     
    INI_FLOAT_SIZE          = 40,       //      

    INI_STRING_DELIMITER    = '\n',     //  
    INI_DELIMITER           = '=',      //    


    //  ,  

    //   
    INI_OK                  =  0,       //   

        //     :
        // if ( __ < 0 ) ...

    INI_FILE_NOT_FOUND      = -1,       //      
    INI_FILE_ALREADY_EXIST  = -2,       //      
    INI_TOO_LARGE_FILE      = -3,       //     
    INI_WRONG_PATH_SIZE     = -4,       //     
    INI_READ_ERROR          = -5,       //   
    INI_WRITE_ERROR         = -6,       //     
    INI_NO_FREE_SLOT        = -7,       //      
    INI_WRONG_SLOT          = -8,       //     
    INI_KEY_NOT_FOUND       = -9,       //      
    INI_WRONG_RETURN_SIZE   = -10,      //  ,       -   (<= 0)


    //   

    //  
    cellbytes = cellbits / charbits;    // -    





//      case    

//   
#define INI_SPACE_CHAR  ' ', '\t'                       //   
#define INI_KEY_STARTS  ' ', '\t', '\r', '\n', '\0'     // ,   
#define INI_STRING_ENDS '\r', '\n', '\0'                // ,  
#define INI_NUMBER_ENDS ' ', '\t', '\r', '\n', '\0'     // ,   





static stock

    //    

    _ini_nSlotUsed      [ INI_MAX_OPENED_FILES ],                               // :   
    _ini_nFileChanged   [ INI_MAX_OPENED_FILES ],                               // :    
    _ini_nFileBusy      [ INI_MAX_OPENED_FILES ],                               // :       
    _ini_nFileSize      [ INI_MAX_OPENED_FILES ],                               //   
    _ini_nDelimPos      [ INI_MAX_OPENED_FILES ] [ INI_MAX_KEYS_IN_FILE ],      //   INI_DELIMITER
    _ini_nKeysCount     [ INI_MAX_OPENED_FILES ],                               // -   
    _ini_szFilePath     [ INI_MAX_OPENED_FILES ] [ INI_MAX_FILENAME_SIZE ],     //   
    _ini_szFileContent  [ INI_MAX_OPENED_FILES ] [ INI_MAX_FILE_SIZE char ];    //  





















/*
        INI   /.

    
            ,      szDefaultContent.
         szDefaultContent    ,      .
           ,      
            .

    :
        szFilePath[]          
        szDefaultContent       , ,   

    :
          < 0  __
*/

stock ini_createFile ( szFilePath[], szDefaultContent[] = "" )
{
    //
    //     
    //

    // ------------
    new nFileNameSize = strlen( szFilePath ); //   

    //    
    if ( nFileNameSize <= 0 || nFileNameSize >= INI_MAX_FILENAME_SIZE )
        return INI_WRONG_PATH_SIZE; //   
    // ------------


    // ------------
    if ( fexist( szFilePath ) ) //    
        return INI_FILE_ALREADY_EXIST; //    -   

    for ( new slot = 0; slot < INI_MAX_OPENED_FILES; slot++ ) //    
        if //      
        (
                _ini_nSlotUsed[slot] != 0
            &&  strcmp( szFilePath, _ini_szFilePath[slot], false ) == 0
        )
            return INI_FILE_ALREADY_EXIST; //    -   
    // ------------



    // ------------
    new nFileSize = strlen( szDefaultContent ); //   a   

    //   
    if ( nFileSize < 0 || nFileSize >= INI_MAX_FILE_SIZE )
        return INI_TOO_LARGE_FILE; //   
    // ------------




    //
    //        
    //

    for ( new slot = 0; slot < INI_MAX_OPENED_FILES; slot++ ) //    
    {
        if ( _ini_nSlotUsed[slot] != 1 ) //   
        {
            // ------------
            _ini_nSlotUsed[slot]        = 1; //   
            _ini_nFileChanged[slot]     = 0; //    
            _ini_nFileSize[slot]        = nFileSize; //     
            _ini_nKeysCount[slot]       = 0; // -   0
            // ------------


            // ------------
            //     ,
            //    INI_DELIMITER   -
            for ( new i = 0;  i < nFileSize && i < INI_MAX_FILE_SIZE;  i++ )
            {
                if (
                        szDefaultContent[i] == INI_DELIMITER //    INI_DELIMITER
                    &&  _ini_nKeysCount[slot] < INI_MAX_KEYS_IN_FILE //      
                ) {
                    _ini_nDelimPos[slot][ _ini_nKeysCount[slot] ] = i; //     INI_DELIMITER
                    _ini_nKeysCount[slot]++; //  -  
                }

                _ini_szFileContent[slot]{i} = szDefaultContent[i];
            }

            _ini_szFileContent[slot]{nFileSize} = 0; //     
            // ------------


            // ------------
            //      
            memcpy( _ini_szFilePath[slot], szFilePath, 0, nFileNameSize * cellbytes );

            _ini_szFilePath[slot][nFileNameSize] = 0; //     
            // ------------


            return slot; //   
        }
    }




    //
    //        
    //

    return INI_NO_FREE_SLOT; //   
    // ------------
}




/*
     INI   /,   .

    
               ,     
        .  -     ,    ,
          / ,      .

    :
        szFilePath[]      

    :
          < 0  __
*/

stock ini_openFile ( szFilePath[] )
{
    //
    //     
    //

    // ------------
    new nFileNameSize = strlen( szFilePath ); //   

    //    
    if ( nFileNameSize <= 0 || nFileNameSize >= INI_MAX_FILENAME_SIZE )
        return INI_WRONG_PATH_SIZE; //   
    // ------------


    if ( ! fexist( szFilePath ) ) //    
        return INI_FILE_NOT_FOUND; //   


    // ------------
    //  -       
    for ( new slot = 0; slot < INI_MAX_OPENED_FILES; slot++ ) //    
        if //      
        (
                _ini_nSlotUsed[slot] != 0
            &&  strcmp( szFilePath, _ini_szFilePath[slot], false ) == 0
        )
            return slot; //    
    // ------------


    // ------------
    new File: pFile = fopen( szFilePath, io_read ); //     

    if ( ! pFile ) //    
        return INI_READ_ERROR; //   
    // ------------


    // ------------
    new nFileSize = flength( pFile ); //   

    if ( nFileSize >= INI_MAX_FILE_SIZE ) //     
    {
        fclose(pFile); //  
        return INI_TOO_LARGE_FILE; //   
    }
    // ------------




    //
    //        
    //

    // ------------
    for ( new slot = 0; slot < INI_MAX_OPENED_FILES; slot++ ) //    
    {
        if ( _ini_nSlotUsed[slot] != 1 ) //   
        {
            // ------------
            _ini_nSlotUsed[slot]        = 1; //   
            _ini_nFileChanged[slot]     = 0; //    
            _ini_nFileSize[slot]        = nFileSize; //     
            _ini_nKeysCount[slot]       = 0; // -   0
            // ------------


            // ------------
            //     ,
            //    INI_DELIMITER   -
            for ( new i = 0, symbol; i < nFileSize && i < INI_MAX_FILE_SIZE; i++ )
            {
                symbol = fgetchar( pFile, 0, false ); //     

                if (
                        symbol == INI_DELIMITER //    INI_DELIMITER
                    &&  _ini_nKeysCount[slot] < INI_MAX_KEYS_IN_FILE //      
                ) {
                    _ini_nDelimPos[slot][ _ini_nKeysCount[slot] ] = i; //     INI_DELIMITER
                    _ini_nKeysCount[slot]++; //  -  
                }

                _ini_szFileContent[slot]{i} = symbol;
            }

            _ini_szFileContent[slot]{nFileSize} = 0; //     

            fclose(pFile); //  
            // ------------


            // ------------
            //      
            memcpy( _ini_szFilePath[slot], szFilePath, 0, nFileNameSize * cellbytes );

            _ini_szFilePath[slot][nFileNameSize] = 0; //     
            // ------------


            return slot; //   
        }
    }
    // ------------




    //
    //        
    //

    // ------------
    fclose(pFile); //  

    return INI_NO_FREE_SLOT; //   
    // ------------
}




/*
     INI ,    .

    
             -       .
            -     .

    :
        nFilePointer    __,   ini_openFile / ini_createFile

    :
          < 0  0  
*/

stock ini_closeFile ( nFilePointer )
{
    if
    (   //      
            nFilePointer >= 0
        &&  nFilePointer < INI_MAX_OPENED_FILES
        &&  _ini_nSlotUsed[nFilePointer] != 0
    )
    {
        if ( _ini_nFileChanged[nFilePointer] != 0 ) //    
        {
            new File: pFile = fopen( _ini_szFilePath[nFilePointer], io_write ); //     

            if ( ! pFile ) //    
                return INI_WRITE_ERROR; //   

            //       
            for ( new i = 0;  i < _ini_nFileSize[nFilePointer];  i++ )
                fputchar( pFile, _ini_szFileContent[nFilePointer]{i}, false );

            fclose(pFile); //  
        }

        _ini_nSlotUsed[nFilePointer] = 0; //    

        return INI_OK; //      
    }

    return INI_WRONG_SLOT; //  :     
}











/*
       INI    .

    
                   
        szReturnValue   . szReturnValue   .

        nSizeOfReturn   ,      -
            (     
         ).

              ,     
           ,  2    \r  \n.

                  
         ,    .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          
        szReturnValue[]            
        nSizeOfReturn       .   , ,   szReturnValue.
                               szReturnValue   ,      enum,
                                  

    :
          < 0  0  
*/

stock ini_getString ( nFilePointer, szKeyName[], szReturnValue[], nSizeOfReturn = sizeof(szReturnValue) )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    if ( nSizeOfReturn <= 0 ) //   -     /  0
        return INI_WRONG_RETURN_SIZE;


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found = 0;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        // ----------------
        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            //    szReturnValue    
            //    found     
            for ( found = 0;  found < nSizeOfReturn;  found++, curFilePos++ )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_STRING_ENDS : //     
                    {
                        szReturnValue[found] = 0; //    
                        break; //  
                    }
                    default :
                        //      szReturnValue
                        szReturnValue[found] = _ini_szFileContent[nFilePointer]{curFilePos};
                }
            }

            szReturnValue[nSizeOfReturn - 1] = 0; //      

            return INI_OK;
            // ----------------
        }
        // ----------------
    }
    // ----------------


    // ----------------
    return INI_KEY_NOT_FOUND;
    // ----------------
}




/*
       INI     .

    
                   
        nReturnValue   . nReturnValue   .

               ,    
         ,  2    \r  \n.

             ,   INI_INTEGER_SIZE - 1.
                 /,
           .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          
        nReturnValue                

    :
          < 0  0  
*/

stock ini_getInteger ( nFilePointer, szKeyName[], & nReturnValue )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found = 0;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        // ----------------
        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            new strValue[INI_INTEGER_SIZE]; //     

            //    strValue    
            //    found     
            for ( found = 0;  found < INI_INTEGER_SIZE;  found++, curFilePos++ )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_NUMBER_ENDS : //      
                    {
                        strValue[found] = 0; //    
                        break; //  
                    }
                    default :
                        //      strValue
                        strValue[found] = _ini_szFileContent[nFilePointer]{curFilePos};
                }
            }

            strValue[INI_INTEGER_SIZE - 1] = 0; //      

            nReturnValue = strval(strValue); //   nReturnValue   

            return INI_OK;
            // ----------------
        }
        // ----------------
    }
    // ----------------


    // ----------------
    return INI_KEY_NOT_FOUND;
    // ----------------
}




/*
       INI      .

    
                   
        fReturnValue   . fReturnValue   .

               ,    
         ,  2    \r  \n.

             ,   INI_FLOAT_SIZE - 1.
                 /,
           .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          
        fReturnValue                

    :
          < 0  0  
*/

stock ini_getFloat ( nFilePointer, szKeyName[], & Float: fReturnValue )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found = 0;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        // ----------------
        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            new strValue[INI_FLOAT_SIZE]; //     

            //    strValue    
            //    found     
            for ( found = 0;  found < INI_INTEGER_SIZE;  found++, curFilePos++ )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_NUMBER_ENDS : //      
                    {
                        strValue[found] = 0; //    
                        break; //  
                    }
                    default :
                        //      strValue
                        strValue[found] = _ini_szFileContent[nFilePointer]{curFilePos};
                }
            }

            strValue[INI_FLOAT_SIZE - 1] = 0; //      

            fReturnValue = floatstr(strValue); //   fReturnValue   

            return INI_OK;
            // ----------------
        }
        // ----------------
    }
    // ----------------


    // ----------------
    return INI_KEY_NOT_FOUND;
    // ----------------
}











/*
    /   INI      .

    
                   
           szKeyValue.

           .     
          ,         .

         /      ,    
         ,  2    \r  \n.    
             ,       
        .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          
        szKeyValue[]           

    :
          < 0  0  
*/

stock ini_setString ( nFilePointer, szKeyName[], szKeyValue[] )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            new nValueLen = strlen(szKeyValue); //     

            //      
            if ( ( curFilePos + nValueLen ) >= INI_MAX_FILE_SIZE )
                return INI_TOO_LARGE_FILE; //      
            // ----------------


            // ----------------
            new fileValueStartPos = curFilePos; //    

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_STRING_ENDS :  break; //     - 
                    default :               continue; //    ,   . 
                }
            }

            //      INI_DELIMITER   
            new filePosOffset = nValueLen - ( /*  */ curFilePos - fileValueStartPos );
            // ----------------


            if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
                return INI_WRITE_ERROR; //       


            // ----------------
            _ini_nFileBusy[nFilePointer] = 1; // :   = 1

            if ( filePosOffset != 0 ) //       
            {
                if ( filePosOffset < 0 ) //     
                {
                    for //  ,        ,
                    ( //       
                        ;
                        curFilePos < _ini_nFileSize[nFilePointer];
                        curFilePos++
                    )
                        _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                            _ini_szFileContent[nFilePointer]{curFilePos};
                }
                else if ( filePosOffset > 0 ) //     
                {
                    new fileValueEndPos = curFilePos;

                    for //  ,        ,
                    ( //    
                        curFilePos = _ini_nFileSize[nFilePointer] - 1;
                        curFilePos >= fileValueEndPos;
                        curFilePos--
                    )
                        _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                            _ini_szFileContent[nFilePointer]{curFilePos};
                }

                //    INI_DELIMITER,     INI_DELIMITER
                for ( kPos++;  kPos < _ini_nKeysCount[nFilePointer];  kPos++ )
                    _ini_nDelimPos[nFilePointer][kPos] += filePosOffset;

                _ini_nFileSize[nFilePointer] += filePosOffset; //   
                _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] } = 0; //     
            }

            curFilePos = fileValueStartPos; //    =    
            for //     
            (
                new valuePos = 0;
                valuePos < nValueLen;
                curFilePos++, valuePos++
            )
                _ini_szFileContent[nFilePointer]{curFilePos} = szKeyValue[valuePos];

            _ini_nFileChanged[nFilePointer]     = 1; // :   = 1
            _ini_nFileBusy[nFilePointer]        = 0; // :   = 0

            return INI_OK;
            // ----------------
        }
    }
    // ----------------


    //
    //       
    //

    // ----------------
    new nValueLen = strlen(szKeyValue); //    

    //      
    if ( ( _ini_nFileSize[nFilePointer] + 5 + nKeyLen + nValueLen ) >= INI_MAX_FILE_SIZE )
        return INI_TOO_LARGE_FILE; //      
    // ----------------


    // ----------------
    if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
        return INI_WRITE_ERROR; //       

    _ini_nFileBusy[nFilePointer] = 1; // :   = 1
    // ----------------


    // ----------------
    if //        
    (
            _ini_nFileSize[nFilePointer] > 0
        &&  _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] - 1 } != INI_STRING_DELIMITER
    )
    {
        //         
        _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] }        = '\r';
        _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] + 1 }    = INI_STRING_DELIMITER;

        _ini_nFileSize[nFilePointer] += 2; //     2
    }

    new curFilePos, strPos; //      //

    for //      
    (
        curFilePos = _ini_nFileSize[nFilePointer], strPos = 0;
        strPos < nKeyLen;
        curFilePos++, strPos++
    )
        _ini_szFileContent[nFilePointer]{curFilePos} = szKeyName[strPos];

    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = ' '; //    

    _ini_nDelimPos[nFilePointer][ _ini_nKeysCount[nFilePointer] ]   = curFilePos; //    INI_DELIMITER
    _ini_nKeysCount[nFilePointer]++; // -    +1

    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = INI_DELIMITER; //     INI_DELIMITER
    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = ' '; //  INI_DELIMITER  

    //      
    for ( strPos = 0;  strPos < nValueLen;  curFilePos++, strPos++ )
        _ini_szFileContent[nFilePointer]{curFilePos} = szKeyValue[strPos];

    _ini_szFileContent[nFilePointer]{curFilePos}    = 0; //    
    _ini_nFileSize[nFilePointer]                    = curFilePos; //   
    _ini_nFileChanged[nFilePointer]                 = 1; // :   = 1
    _ini_nFileBusy[nFilePointer]                    = 0; // :   = 0

    return INI_OK;
    // ----------------
}




/*
    /   INI       .

    
                   
           nKeyValue.

           ,     
          ,         .

               ,    
         ,  2    \r  \n.    
           ,  cellmax  ,  cellmin,
               .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          
        nKeyValue             

    :
          < 0  0  
*/

stock ini_setInteger ( nFilePointer, szKeyName[], nKeyValue )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            new szKeyValue[INI_INTEGER_SIZE]; //      
            format( szKeyValue, INI_INTEGER_SIZE, "%i", nKeyValue );
            // ----------------


            // ----------------
            new nValueLen = strlen(szKeyValue); //     

            //      
            if ( ( curFilePos + nValueLen ) >= INI_MAX_FILE_SIZE )
                return INI_TOO_LARGE_FILE; //      
            // ----------------


            // ----------------
            new fileValueStartPos = curFilePos; //    

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_NUMBER_ENDS :  break; //     - 
                    default :               continue; //    ,   . 
                }
            }

            //      INI_DELIMITER   
            new filePosOffset = nValueLen - ( /*  */ curFilePos - fileValueStartPos );
            // ----------------


            if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
                return INI_WRITE_ERROR; //       


            // ----------------
            _ini_nFileBusy[nFilePointer] = 1; // :   = 1

            if ( filePosOffset != 0 ) //       
            {
                if ( filePosOffset < 0 ) //     
                {
                    for //  ,        ,
                    ( //       
                        ;
                        curFilePos < _ini_nFileSize[nFilePointer];
                        curFilePos++
                    )
                        _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                            _ini_szFileContent[nFilePointer]{curFilePos};
                }
                else if ( filePosOffset > 0 ) //     
                {
                    new fileValueEndPos = curFilePos;

                    for //  ,        ,
                    ( //    
                        curFilePos = _ini_nFileSize[nFilePointer] - 1;
                        curFilePos >= fileValueEndPos;
                        curFilePos--
                    )
                        _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                            _ini_szFileContent[nFilePointer]{curFilePos};
                }

                //    INI_DELIMITER,     INI_DELIMITER
                for ( kPos++;  kPos < _ini_nKeysCount[nFilePointer];  kPos++ )
                    _ini_nDelimPos[nFilePointer][kPos] += filePosOffset;

                _ini_nFileSize[nFilePointer] += filePosOffset; //   
                _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] } = 0; //     
            }

            curFilePos = fileValueStartPos; //    =    
            for //     
            (
                new valuePos = 0;
                valuePos < nValueLen;
                curFilePos++, valuePos++
            )
                _ini_szFileContent[nFilePointer]{curFilePos} = szKeyValue[valuePos];

            _ini_nFileChanged[nFilePointer]     = 1; // :   = 1
            _ini_nFileBusy[nFilePointer]        = 0; // :   = 0

            return INI_OK;
            // ----------------
        }
    }
    // ----------------


    //
    //       
    //

    // ----------------
    new szKeyValue[INI_INTEGER_SIZE]; //      
    format( szKeyValue, INI_INTEGER_SIZE, "%i", nKeyValue );
    // ----------------


    // ----------------
    new nValueLen = strlen(szKeyValue); //    

    //      
    if ( ( _ini_nFileSize[nFilePointer] + 5 + nKeyLen + nValueLen ) >= INI_MAX_FILE_SIZE )
        return INI_TOO_LARGE_FILE; //      
    // ----------------


    // ----------------
    if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
        return INI_WRITE_ERROR; //       

    _ini_nFileBusy[nFilePointer] = 1; // :   = 1
    // ----------------


    // ----------------
    if //        
    (
            _ini_nFileSize[nFilePointer] > 0
        &&  _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] - 1 } != INI_STRING_DELIMITER
    )
    {
        //         
        _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] }        = '\r';
        _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] + 1 }    = INI_STRING_DELIMITER;

        _ini_nFileSize[nFilePointer] += 2; //     2
    }

    new curFilePos, strPos; //      //

    for //      
    (
        curFilePos = _ini_nFileSize[nFilePointer], strPos = 0;
        strPos < nKeyLen;
        curFilePos++, strPos++
    )
        _ini_szFileContent[nFilePointer]{curFilePos} = szKeyName[strPos];

    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = ' '; //    

    _ini_nDelimPos[nFilePointer][ _ini_nKeysCount[nFilePointer] ]   = curFilePos; //    INI_DELIMITER
    _ini_nKeysCount[nFilePointer]++; // -    +1

    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = INI_DELIMITER; //     INI_DELIMITER
    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = ' '; //  INI_DELIMITER  

    //      
    for ( strPos = 0;  strPos < nValueLen;  curFilePos++, strPos++ )
        _ini_szFileContent[nFilePointer]{curFilePos} = szKeyValue[strPos];

    _ini_szFileContent[nFilePointer]{curFilePos}    = 0; //    
    _ini_nFileSize[nFilePointer]                    = curFilePos; //   
    _ini_nFileChanged[nFilePointer]                 = 1; // :   = 1
    _ini_nFileBusy[nFilePointer]                    = 0; // :   = 0

    return INI_OK;
    // ----------------
}




/*
    /   INI        .

    
                   
           fKeyValue.

           ,     
          ,         .

               ,    
         ,  2    \r  \n.    
           /  ,  
            .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          
        fKeyValue              

    :
          < 0  0  
*/

stock ini_setFloat ( nFilePointer, szKeyName[], Float: fKeyValue )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            new szKeyValue[INI_FLOAT_SIZE]; //      
            format( szKeyValue, INI_FLOAT_SIZE, "%f", fKeyValue ); //    fKeyValue  szKeyValue
            // ----------------


            // ----------------
            new nValueLen = strlen(szKeyValue); //     

            //      
            if ( ( curFilePos + nValueLen ) >= INI_MAX_FILE_SIZE )
                return INI_TOO_LARGE_FILE; //      
            // ----------------


            // ----------------
            new fileValueStartPos = curFilePos; //    

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_NUMBER_ENDS :  break; //     - 
                    default :               continue; //    ,   . 
                }
            }

            //      INI_DELIMITER   
            new filePosOffset = nValueLen - ( /*  */ curFilePos - fileValueStartPos );
            // ----------------


            if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
                return INI_WRITE_ERROR; //       


            // ----------------
            _ini_nFileBusy[nFilePointer] = 1; // :   = 1

            if ( filePosOffset != 0 ) //       
            {
                if ( filePosOffset < 0 ) //     
                {
                    for //  ,        ,
                    ( //       
                        ;
                        curFilePos < _ini_nFileSize[nFilePointer];
                        curFilePos++
                    )
                        _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                            _ini_szFileContent[nFilePointer]{curFilePos};
                }
                else if ( filePosOffset > 0 ) //     
                {
                    new fileValueEndPos = curFilePos;

                    for //  ,        ,
                    ( //    
                        curFilePos = _ini_nFileSize[nFilePointer] - 1;
                        curFilePos >= fileValueEndPos;
                        curFilePos--
                    )
                        _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                            _ini_szFileContent[nFilePointer]{curFilePos};
                }

                //    INI_DELIMITER,     INI_DELIMITER
                for ( kPos++;  kPos < _ini_nKeysCount[nFilePointer];  kPos++ )
                    _ini_nDelimPos[nFilePointer][kPos] += filePosOffset;

                _ini_nFileSize[nFilePointer] += filePosOffset; //   
                _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] } = 0; //     
            }

            curFilePos = fileValueStartPos; //    =    
            for //     
            (
                new valuePos = 0;
                valuePos < nValueLen;
                curFilePos++, valuePos++
            )
                _ini_szFileContent[nFilePointer]{curFilePos} = szKeyValue[valuePos];

            _ini_nFileChanged[nFilePointer]     = 1; // :   = 1
            _ini_nFileBusy[nFilePointer]        = 0; // :   = 0

            return INI_OK;
            // ----------------
        }
    }
    // ----------------


    //
    //       
    //

    // ----------------
    new szKeyValue[INI_FLOAT_SIZE]; //      
    format( szKeyValue, INI_FLOAT_SIZE, "%f", fKeyValue ); //    fKeyValue  szKeyValue
    // ----------------


    // ----------------
    new nValueLen = strlen(szKeyValue); //    

    //      
    if ( ( _ini_nFileSize[nFilePointer] + 5 + nKeyLen + nValueLen ) >= INI_MAX_FILE_SIZE )
        return INI_TOO_LARGE_FILE; //      
    // ----------------


    // ----------------
    if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
        return INI_WRITE_ERROR; //       

    _ini_nFileBusy[nFilePointer] = 1; // :   = 1
    // ----------------


    // ----------------
    if //        
    (
            _ini_nFileSize[nFilePointer] > 0
        &&  _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] - 1 } != INI_STRING_DELIMITER
    )
    {
        //         
        _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] }        = '\r';
        _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] + 1 }    = INI_STRING_DELIMITER;

        _ini_nFileSize[nFilePointer] += 2; //     2
    }

    new curFilePos, strPos; //      //

    for //      
    (
        curFilePos = _ini_nFileSize[nFilePointer], strPos = 0;
        strPos < nKeyLen;
        curFilePos++, strPos++
    )
        _ini_szFileContent[nFilePointer]{curFilePos} = szKeyName[strPos];

    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = ' '; //    

    _ini_nDelimPos[nFilePointer][ _ini_nKeysCount[nFilePointer] ]   = curFilePos; //    INI_DELIMITER
    _ini_nKeysCount[nFilePointer]++; // -    +1

    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = INI_DELIMITER; //     INI_DELIMITER
    _ini_szFileContent[nFilePointer]{ curFilePos++ }                = ' '; //  INI_DELIMITER  

    //      
    for ( strPos = 0;  strPos < nValueLen;  curFilePos++, strPos++ )
        _ini_szFileContent[nFilePointer]{curFilePos} = szKeyValue[strPos];

    _ini_szFileContent[nFilePointer]{curFilePos}    = 0; //    
    _ini_nFileSize[nFilePointer]                    = curFilePos; //   
    _ini_nFileChanged[nFilePointer]                 = 1; // :   = 1
    _ini_nFileBusy[nFilePointer]                    = 0; // :   = 0

    return INI_OK;
    // ----------------
}




/*
       INI      .

    
                   
         /.

         /      ,
             ,  2    \r  \n.

                 ,
               .

    :
        nFilePointer        __,   ini_openFile / ini_createFile
        szKeyName[]          

    :
          < 0  0  
*/

stock ini_removeKey ( nFilePointer, szKeyName[] )
{
    // ----------------
    if //      
    (
            nFilePointer < 0
        ||  nFilePointer >= INI_MAX_OPENED_FILES
        ||  _ini_nSlotUsed[nFilePointer] != 1
    )
        return INI_WRONG_SLOT; //  :     
    // ----------------


    // ----------------
    new nKeyLen = strlen(szKeyName); //     

    if ( nKeyLen <= 0 ) //    
        return INI_KEY_NOT_FOUND;
    // ----------------


    // ----------------
    for //         
    (
        new kPos = 0, curFilePos, found;
        kPos < _ini_nKeysCount[nFilePointer];
        kPos++
    )
    {
        // ----------------
        found = 0; // ,      = 0

        for //    
        (
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] - 1; // . .  = . . INI_DELIMITER - 1
            curFilePos >= 0; //   .  >= 0
            curFilePos-- //    . .  -= 1
        )
        {
            switch ( _ini_szFileContent[nFilePointer]{curFilePos} ) //      . . 
            {
                case INI_SPACE_CHAR :           continue; //    ,   .  
                case INI_STRING_DELIMITER :     break; //    
                default : //    
                {
                    found = 1; //    
                    break; //  
                }
            }
        }

        //      ,   .  INI_DELIMITER
        if ( found != 1 ) continue;
        // ----------------


        //        
        for ( new curKeyPos = nKeyLen - 1;  curKeyPos >= 0;  curFilePos--, curKeyPos-- )
        {
            if
            (
                    curFilePos < 0 //     < 0
                ||  _ini_szFileContent[nFilePointer]{curFilePos} != szKeyName[curKeyPos] //      
                ||  _ini_szFileContent[nFilePointer]{curFilePos} == INI_STRING_DELIMITER //      INI_STRING_DELIMITER
            )
            {
                found = 0; // ,   
                break; //  
            }
        }


        if ( found != 0 ) //      
        {
            //       ,      
            if ( curFilePos >= 0 )
            {
                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_KEY_STARTS : {}
                    default: continue;
                }
            }


            //    
            new keyStartPos = ( curFilePos <= 0 ) ? 0 : curFilePos + 1;


            // ----------------
            //       1    INI_DELIMITER
            curFilePos = _ini_nDelimPos[nFilePointer][kPos] + 1;

            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_SPACE_CHAR :   continue; //    ,   . 
                    default :               break; //    
                }
            }
            // ----------------


            // ----------------
            //    ,     curFilePos
            for ( ; ; curFilePos++ )
            {
                if ( curFilePos >= _ini_nFileSize[nFilePointer] ) break;

                switch ( _ini_szFileContent[nFilePointer]{curFilePos} )
                {
                    case INI_STRING_ENDS :  break; //     - 
                    default :               continue; //    ,   . 
                }
            }

            //      INI_DELIMITER   
            new filePosOffset = keyStartPos - curFilePos;
            // ----------------


            if ( _ini_nFileBusy[nFilePointer] != 0 ) //       
                return INI_WRITE_ERROR; //       


            // ----------------
            _ini_nFileBusy[nFilePointer] = 1; // :   = 1

            //   ,     
            for ( ; curFilePos <= _ini_nFileSize[nFilePointer]; curFilePos++ )
                _ini_szFileContent[nFilePointer]{ curFilePos + filePosOffset } =
                    _ini_szFileContent[nFilePointer]{curFilePos};

            //   INI_DELIMITER,     INI_DELIMITER
            for ( ;  kPos < _ini_nKeysCount[nFilePointer];  kPos++ )
                _ini_nDelimPos[nFilePointer][kPos] = _ini_nDelimPos[nFilePointer][kPos + 1] + filePosOffset;

            _ini_nKeysCount[nFilePointer]--;
            _ini_nFileSize[nFilePointer] += filePosOffset; //   
            _ini_szFileContent[nFilePointer]{ _ini_nFileSize[nFilePointer] } = 0; //     

            _ini_nFileChanged[nFilePointer]     = 1; // :   = 1
            _ini_nFileBusy[nFilePointer]        = 0; // :   = 0

            return INI_OK;
            // ----------------
        }
    }
    // ----------------


    //
    //       
    //

    // ----------------
    return INI_KEY_NOT_FOUND;
    // ----------------
}




/*
             .

    
         -     0 (  ),  
        , ,   .        
             ,     
                  .

                128 ,
               !

    :
        nErrorCode       ,    

    :
            ,   

    :
        new ini = ini_openFile(" "); //    

        if ( ini < 0 ) print( ini_getErrorInfo(ini) );
        else
        {
            new number, result = ini_getInteger( ini, " ", number ); //     

            if ( result < 0 ) print( ini_getErrorInfo(result) );

            ini_closeFile(ini);
        }
*/

stock ini_getErrorInfo ( nErrorCode )
{
    new error_ms[200] = " ";

    if ( nErrorCode >= 0 ) return error_ms;

    switch ( nErrorCode )
    {
        case INI_FILE_NOT_FOUND :     error_ms = "INI ,   `ini_openFile`,  , ,     ";
        case INI_FILE_ALREADY_EXIST : error_ms = "INI ,   `ini_createFile`,  ,   /  ";
        case INI_TOO_LARGE_FILE :     error_ms = "     INI , ..  INI      " #INI_MAX_FILE_SIZE " (),      " #INI_MAX_KEYS_IN_FILE " ";
        case INI_WRONG_PATH_SIZE :    error_ms = "   INI ,   `ini_openFile` / `ini_createFile`,    " #INI_MAX_FILENAME_SIZE " ()";
        case INI_READ_ERROR :         error_ms = "   INI   , ,    ";
        case INI_WRITE_ERROR :        error_ms = "    INI   , ,    ";
        case INI_NO_FREE_SLOT :       error_ms = "  " #INI_MAX_OPENED_FILES "   INI  ,  /  1  ,     1   ";
        case INI_WRONG_SLOT :         error_ms = "  ID  INI , ,   INI   ,   ID     ";
        case INI_KEY_NOT_FOUND :      error_ms = "      INI ";
        case INI_WRONG_RETURN_SIZE :  error_ms = "      INI ,   `nSizeOfReturn`  `ini_getString`  <= 0,    > 0  ";

        default:                      error_ms = " ";
    }

    return error_ms;
}
